/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.IMTPException;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.PlatformManager;
import jade.core.Service;
import jade.core.ServiceDescriptor;
import jade.core.ServiceException;
import jade.core.UnreachableException;
import jade.imtp.leap.Command;
import jade.imtp.leap.DispatcherException;
import jade.imtp.leap.Stub;
import jade.security.JADESecurityException;
import java.util.Vector;

class PlatformManagerStub
extends Stub
implements PlatformManager {
    static final int GET_PLATFORM_NAME = 1;
    static final int ADD_NODE = 2;
    static final int REMOVE_NODE = 3;
    static final int ADD_SLICE = 4;
    static final int REMOVE_SLICE = 5;
    static final int ADD_REPLICA = 6;
    static final int REMOVE_REPLICA = 7;
    static final int FIND_SLICE = 8;
    static final int FIND_ALL_SLICES = 9;
    static final int ADOPT = 10;
    static final int PING = 11;
    private static final String AUTH_EXCEPTION = "jade.security.JADESecurityException";
    private static final String SERVICE_EXCEPTION = "jade.core.ServiceException";

    protected PlatformManagerStub() {
        super(0);
    }

    public String getPlatformName() throws IMTPException {
        Command cmd = new Command(1, this.remoteID);
        try {
            Command result = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            this.checkResult(result, null);
            return (String)result.getParamAt(0);
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public String getLocalAddress() {
        if (this.remoteTAs.size() > 0) {
            return this.remoteTAs.get(0).toString();
        }
        return null;
    }

    public void setLocalAddress(String addr) {
    }

    public String addNode(NodeDescriptor desc, Vector services, boolean propagated) throws IMTPException, ServiceException, JADESecurityException {
        try {
            Command cmd = new Command(2, this.remoteID);
            cmd.addParam(desc);
            cmd.addParam(services);
            cmd.addParam(new Boolean(propagated));
            Command result = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            switch (this.checkResult(result, new String[]{AUTH_EXCEPTION, SERVICE_EXCEPTION})) {
                case 1: {
                    throw new JADESecurityException((String)result.getParamAt(1));
                }
                case 2: {
                    throw new ServiceException((String)result.getParamAt(1));
                }
            }
            return (String)result.getParamAt(0);
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public void removeNode(NodeDescriptor desc, boolean propagate) throws IMTPException, ServiceException {
        try {
            Command cmd = new Command(3, this.remoteID);
            cmd.addParam(desc);
            cmd.addParam(new Boolean(propagate));
            Command res = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            if (this.checkResult(res, new String[]{SERVICE_EXCEPTION}) > 0) {
                throw new ServiceException((String)res.getParamAt(1));
            }
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public void addSlice(ServiceDescriptor service, NodeDescriptor dsc, boolean propagated) throws IMTPException, ServiceException {
        try {
            Command cmd = new Command(4, this.remoteID);
            cmd.addParam(service);
            cmd.addParam(dsc);
            cmd.addParam(new Boolean(propagated));
            Command res = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            if (this.checkResult(res, new String[]{SERVICE_EXCEPTION}) > 0) {
                throw new ServiceException((String)res.getParamAt(1));
            }
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public void removeSlice(String serviceKey, String sliceKey, boolean propagated) throws IMTPException, ServiceException {
        try {
            Command cmd = new Command(5, this.remoteID);
            cmd.addParam(serviceKey);
            cmd.addParam(sliceKey);
            cmd.addParam(new Boolean(propagated));
            Command res = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            if (this.checkResult(res, new String[]{SERVICE_EXCEPTION}) > 0) {
                throw new ServiceException((String)res.getParamAt(1));
            }
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public void addReplica(String newAddr, boolean propagated) throws IMTPException, ServiceException {
        try {
            Command cmd = new Command(6, this.remoteID);
            cmd.addParam(newAddr);
            cmd.addParam(new Boolean(propagated));
            Command res = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            if (this.checkResult(res, new String[]{SERVICE_EXCEPTION}) > 0) {
                throw new ServiceException((String)res.getParamAt(1));
            }
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public void removeReplica(String address, boolean propagated) throws IMTPException, ServiceException {
        try {
            Command cmd = new Command(7, this.remoteID);
            cmd.addParam(address);
            cmd.addParam(new Boolean(propagated));
            Command res = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            if (this.checkResult(res, new String[]{SERVICE_EXCEPTION}) > 0) {
                throw new ServiceException((String)res.getParamAt(1));
            }
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public void adopt(Node n, Node[] children) throws IMTPException {
        try {
            Command cmd = new Command(10, this.remoteID);
            cmd.addParam(n);
            cmd.addParam(children);
            Command result = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            this.checkResult(result, null);
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public void ping() throws IMTPException {
        try {
            Command cmd = new Command(11, this.remoteID);
            Command result = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            this.checkResult(result, null);
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public Service.Slice findSlice(String serviceKey, String sliceKey) throws IMTPException, ServiceException {
        try {
            Command cmd = new Command(8, this.remoteID);
            cmd.addParam(serviceKey);
            cmd.addParam(sliceKey);
            Command res = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            if (this.checkResult(res, new String[]{SERVICE_EXCEPTION}) > 0) {
                throw new ServiceException((String)res.getParamAt(1));
            }
            return (Service.Slice)res.getParamAt(0);
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public Vector findAllSlices(String serviceKey) throws IMTPException, ServiceException {
        try {
            Command cmd = new Command(9, this.remoteID);
            cmd.addParam(serviceKey);
            Command res = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            if (this.checkResult(res, new String[]{SERVICE_EXCEPTION}) > 0) {
                throw new ServiceException((String)res.getParamAt(1));
            }
            return (Vector)res.getParamAt(0);
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }
}

